function f=wiglis2h(h2d,s,epsilon);

% f=wiglis2h(h2d,s,epsilon);
% Etant donne un signal s (remplace par la 
% transformee de Hilbert de sa partie reelle) et une fenetre 
% bidimensionnelle h2d, cette fonction 
% calcule la version reassignee de la  
% transformee de Wigner-Ville du signal s  
% lissee via la fenetre h2d. Le seuil epsilon est 
% le seuil en dessous duquel il n'est pas procede au
% reassignement (si |h2d*WV[s] (t,omega)| <= epsilon, la valeur 
% 0 est assignee au point (t,omega)). L'intervalle 
% de frequence est [0, pi/tau]. 

I=wigh(s);
[N1,N2]=size(I); 
reassign=zeros(N1,N2);
vt=1:size(I,2);
vf=1:size(I,1);
prw=vpm(vf,I);
prt=vpm(vt,I'); 
prt=prt';
nt=conv2(prt,h2d,'same');
nw=conv2(prw,h2d,'same');

Ifilt=conv2(I,h2d,'same');
for n=1:N1
  for m=1:N2
      if( abs(Ifilt(n,m))>epsilon )
        nn=nt(n,m)/Ifilt(n,m);
        nn1=round(abs(nn));
        nm=nw(n,m)/Ifilt(n,m);
        nm1=round(abs(nm));
        if (nn1>N1-1) nn1=N1; end;
        if (nm1>N2-1) nm1=N2; end;
        if (nn1<1) nn1=1; end;
        if (nm1<1) nm1=1; end;
        reassign(nn1,nm1)=reassign(nn1,nm1)+Ifilt(n,m);
      end;
  end;
end;
reassign=reassign';
m=size(reassign);
f=zeros(m);
for k=1:m(1)
   f(k,:)=reassign(m(1)+1-k,:);
end

