function [U,orig,recomp,etiq]=wpack4_2D(A,nlev,K);

%  [U, orig, recomp, etiq]=wpack4_2D(s,nlev,K);
%decomposition en paquets d'ondelettes 
%(analyse multi-resolution de Daubechies 
% a 4 parametres avec recherche de la base orthornormee 
%dans laquelle l'entropie est minimale) d'une image A ; 
%nlev est le nombre de niveaux d'echelle ; les paquets sont les 
%blocs de la matrice U ; tous ces blocs (mis bout 
%a bout) sont de meme taille et le nombre de blocs est 
%donne par la longueur du vecteur colonne etiq ; 
%les etiquettes des blocs (pris dans l'ordre) 
%sont les lignes de etiq (RR pour resume, DD pour 
%details obliques, RD pour details verticaux, DR pour 
%details horizontaux,00 pour l'operateur identite). 
%L'entropie utilisee ici est l'entropie de Shannon non normalisee.
%L'image est mise dans un cadre (entouree d'une bande de zeros de 
%largeur K). L'image reconstituee est recomp.L'image originelle dans 
%son cadre est orig. La matrice U est une suite de l1 blocs de meme taille,
%l1 etant le nombre de lignes de etiq. Le k-eme bloc (a partir 
%de la gauche) correspond a la composante dans la base ayant pour etiquette 
%etiq(k,:). 

[N1,N2]=size(A);
M=N2+2*K;
A=[zeros(N1,K) A zeros(N1,K)];
A=[zeros(K,M);A;zeros(K,M)];
orig=A;
N1=N1+2*K;
N2=N2+2*K;
U=[];
etiq=[];
[RR,DD,RD,DR,m1,m2]=daub4_2D(A); 
eA=entr2D(A);
if nlev==1
   efRR=entr2D(RR);
   efDD=entr2D(DD);
   efRD=entr2D(RD);
   efDR=entr2D(DR);
   mfRR=RR;
   mfDD=DD;
   mfRD=RD;
   mfDR=DR;
   IRR=iRRdaub4_2D(RR);
   IDD=iDDdaub4_2D(DD);
   IRD=iRDdaub4_2D(RD);
   IDR=iDRdaub4_2D(DR);
   if efRR+efDD+efRD+efDR <eA
      U=[IRR;IDD;IRD;IDR];
      etiq=['(RR)';'(DD)';'(RD)';'(DR)'];
      
    %ici, on peut modifier eventuellement les coefficients intervenant 
    %dans les divers composants de la base optimale (modifier RR,DD,RD,DR)
    
    else
       
    %ici, on peut modifier eventuellement les coefficients intervenant 
    %dans les divers composants de la base optimale  
    
    %modif = matrice de taille size(A) dependant de A; 
    %U=Amodif
     
    U=A;
    etiq=['(00)'];
   end
else
   
   [p,ncm]=size(U);
   [efRR, mfRR, mRR]=wpack4_2Daux(RR,nlev-1);
   [efDD, mfDD, mDD]=wpack4_2Daux(DD,nlev-1);
   [efRD, mfRD, mRD]=wpack4_2Daux(RD,nlev-1);
   [efDR, mfDR, mDR]=wpack4_2Daux(DR,nlev-1);

if efRR+efDD+efRD+efDR<eA
   [nRR,nRR1]=size(mRR);
   [nDD,nDD1]=size(mDD);
   [nRD,nRD1]=size(mRD);
   [nDR,nDR1]=size(mDR);
   
   [pRR,qRR]=size(mfRR);
   [pDD,qDD]=size(mfDD);
   [pRD,qRD]=size(mfRD);
   [pDR,qDR]=size(mfDR);
   nrRR=fix(qRR/nRR);
   nrDD=fix(qDD/nDD);
   nrRD=fix(qRD/nRD);
   nrDR=fix(qDR/nDR);
  
   
   for i=1:nRR
      IRR=iRRdaub4_2D(mfRR(:,1+(i-1)*nrRR:i*nrRR));
      [pRR,qRR]=size(IRR);
      irr=['(RR)' mRR(i,:)];
      [p,ncm]=size(U);
      if p~=0
         [l,l1]=size(etiq);
         q=fix(ncm/l);

			if q<qRR
				IRR=IRR(:,1:q);
			else
				IRR=[IRR zeros(pRR,(q-qRR))];
			end;
         if p<pRR
            IRR=IRR(1:p,:);
         else
            IRR=[IRR;zeros(p-pRR,q)];
         end
       end
    
      U=[U IRR];
      etiq=[etiq ;irr];
   end;	
   
   for i=1:nDD
      IDD=iDDdaub4_2D(mfDD(:,1+(i-1)*nrDD:i*nrDD));
      [pDD,qDD]=size(IDD);
      idd=['(DD)' mDD(i,:)]; 
      [p,ncm]=size(U);
      if p~=0
         [l,l1]=size(etiq);
         q=fix(ncm/l);

			if q<qDD
				IDD=IDD(:,1:q);
			else
				IDD=[IDD zeros(pDD,(q-qDD))];
			end;
         if p<pDD
            IDD=IDD(1:p,:);
         else
            IDD=[IDD;zeros(p-pDD,q)];
         end
      end
      
      U=[U IDD];
      etiq=[etiq;idd];
   end;	

   for i=1:nRD
      IRD=iRDdaub4_2D(mfRD(:,1+(i-1)*nrRD:i*nrRD));
      [pRD,qRD]=size(IRD);
      ird=['(RD)' mRD(i,:)];
      [p,ncm]=size(U);
      if p~=0
         [l,l1]=size(etiq);
         q=fix(ncm/l);

         if q<qRD
				IRD=IRD(:,1:q);
			else
				IRD=[IRD zeros(pRD,(q-qRD))];
			end
         if p<pRD
            IRD=IRD(1:p,:);
         else
            IRD=[IRD;zeros(p-pRD,q)];
         end
      end
      
      U=[U IRD];
      etiq=[etiq;ird];
   end;	
   
   
   for i=1:nDR
      IDR=iDRdaub4_2D(mfDR(:,1+(i-1)*nrDR:i*nrDR));
      [pDR,qDR]=size(IDR);
      idr=['(DR)' mDR(i,:)]; 
      [p,ncm]=size(U);
      if p~=0
         [l,l1]=size(etiq);
         q=fix(ncm/l);

			if q<qDR
				IDR=IDR(:,1:q);
			else
				IDR=[IDR zeros(pDR,(q-qDR))];
			end;
         if p<pDR
            IDR=IDR(1:p,:);
         else
            IDR=[IDR;zeros(p-pDR,q)];
         end
      end
      
      U=[U IDR];
      etiq=[etiq;idr];
   end;	
   
else
    %ici, on peut modifier eventuellement les coefficients intervenant 
    %dans les divers composants de la base optimale : 
    
    %Amodif = matrice de taille size(A) dependant de A; 
    %U=Amodif
    
    
   U=A;
   etiq=['(00)'];
end;
end;


   [M,N]=size(U);
   [l1,l2]=size(etiq);
   MM=fix(N/l1);
   recomp=zeros(M,MM);
   for i=1:l1
       recomp=recomp+U(:,1+(i-1)*MM:i*MM);
   end
   recomp=recomp(1:min(N1,M),1:min(N2,MM));
   orig=orig(1:min(N1,M),1:min(N2,MM));
 
   
   
   
   
   


