function [U,orig,recomp,etiq]=wpack8(s,nlev,K);

%  [U, orig, recomp, etiq]=wpack8(s,nlev,K);
%decomposition en paquets d'ondelettes 
%(analyse multi-resolution de Daubechies 
% a 8 parametres); nlev est le nombre de 
%niveaux d'echelle; les paquets sont les 
%lignes de U; les etiquettes correspondantes
%sont les lignes de etiq (R pour resume, D pour 
%detail,0 pour l'operateur identite). L'entropie 
%est l'entropie de Shannon non normalisee. Le 
%signal orig est le signal originel prolonge par K 
%zeros a gauche et a droite. Le signal recomp est 
%le signal orig recompose (somme des lignes de U 
%convenablement tronquees). 

M=length(s);
x=[zeros(1,K) s zeros(1,K)];
orig=x;
N=length(x);

U=[];
etiq=[];
r=rdaub8(x);
d=ddaub8(x);
ex=entr(x);
if nlev==1
	efs=entr(r);
	efd=entr(d);
	mfs=r;
   mfd=d;
   ir=irdaub8(r);
   id=iddaub8(d);
   if efs+efd<ex
      U=[ir;id];
      etiq=['R';'D'];
   else
      U=x;
      etiq=['O'];
   end
else
[efs, mfs, ms]=wpack8_aux(r,nlev-1);
[efd, mfd, md]=wpack8_aux(d,nlev-1);

if efs+efd<entr(x)
   [nrs ncs]=size(mfs);
   for i=1:nrs
		[nrm ncm]=size(U);
      ir=irdaub8(mfs(i,:));
      irr=['R' ms(i,:)]; 
		if ncm~=0
			if ncm<length(ir)
				ir=ir(1:ncm);
			else
				ir=[ir zeros(1,(ncm-length(ir)))];
			end;
		end;		
      U=[U;ir];
      etiq=[etiq;irr];
	end;	

	[nrd ncd]=size(mfd);
	for i=1:nrd
		[nrm ncm]=size(U);
      id=iddaub8(mfd(i,:));
      idd=['D' md(i,:)];
		if ncm ~= 0
			if ncm<length(id)
				id=id(1:ncm);
			else
				id=[id zeros(1,(ncm-length(id)))];
			end;
		end;
      U=[U;id];
      etiq=[etiq;idd];
      end;			
else
   U=x;
   etiq=['0'];
end;
end;

recomp=sum(U);
[M,NN]=size(U);
orig=orig(1:min(N,NN));
recomp=recomp(1:min(N,NN));

