function [eB,mrB,mB]=wpack8_2Daux(B,nlev);

%  [eB,mrB,mB]=wpack8_2Daux(B,nlev);
% Programme auxiliaire pour l'implementation de 
% la decomposition en paquets d'ondelettes 2D 
% (analyse multiresolution de Daubechies a 8 parametres).
% L'entropie est l'entropie de Shannon non normalisee. 

eBinit=entr2D(B);
mrB=[];
mB=[];
[RR,DD,RD,DR,m1,m2]=daub8_2D(B);

if nlev==1
   efRR=entr2D(RR);
   efDD=entr2D(DD);
   efRD=entr2D(RD);
   efDR=entr2D(DR);
 if efRR+efDD+efRD+efDR <eBinit  
   IRR=iRRdaub8_2D(RR);
   IDD=iDDdaub8_2D(DD);
   IRD=iRDdaub8_2D(RD);
   IDR=iDRdaub8_2D(DR);
   eB=efRR+efDD+efRD+efDR;
   mrB=[IRR IDD IRD IDR];
   mB = ['(RR)';'(DD)';'(RD)';'(DR)']; 
   
   %ici, on peut modifier eventuellement les coefficients intervenant 
   %dans les divers composants de la base optimale (modifier RR,DD,RD,DR)
 else
   eB=eBinit;
   mrB=B;
  
   %ici, on peut modifier eventuellement les coefficients intervenant 
   %dans les divers composants de la base optimale  
    
   %modif = matrice de taille size(B) dependant de B; 
   %mrB=Bmodif  
   
   
   
   mB=['(00)'];
end
else
   
   [efRR, mfRR, mRR]=wpack8_2Daux(RR,nlev-1);
   [efDD, mfDD, mDD]=wpack8_2Daux(DD,nlev-1);
   [efRD, mfRD, mRD]=wpack8_2Daux(RD,nlev-1);
   [efDR, mfDR, mDR]=wpack8_2Daux(DR,nlev-1);
   
   
if efRR+efDD+efRD+efDR <eBinit
   [nRR,nRR1]=size(mRR);
   [nDD,nDD1]=size(mDD);
   [nRD,nRD1]=size(mRD);
   [nDR,nDR1]=size(mDR);
   
   [pRR,qRR]=size(mfRR);
   [pDD,qDD]=size(mfDD);
   [pRD,qRD]=size(mfRD);
   [pDR,qDR]=size(mfDR);
   nrRR=fix(qRR/nRR);
   nrDD=fix(qDD/nDD);
   nrRD=fix(qRD/nRD);
   nrDR=fix(qDR/nDR);
   
   for i=1:nRR
      IRR=iRRdaub8_2D(mfRR(:,1+(i-1)*nrRR:i*nrRR));
      [pRR,qRR]=size(IRR);
      irr=['(RR)' mRR(i,:)];
      [p,ncm]=size(mrB);
      if p~=0
         [l,l1]=size(mB);
         q=fix(ncm/l);

			if q<qRR
				IRR=IRR(:,1:q);
			else
				IRR=[IRR zeros(pRR,(q-qRR))];
			end;
         if p<pRR
            IRR=IRR(1:p,:);
         else
            IRR=[IRR;zeros(p-pRR,q)];
         end
      end
      
      mrB=[mrB IRR];
      mB=[mB ;irr];
   end;	
   
   for i=1:nDD
      IDD=iDDdaub8_2D(mfDD(:,1+(i-1)*nrDD:i*nrDD));
      [pDD,qDD]=size(IDD);
      idd=['(DD)' mDD(i,:)];
      [p,ncm]=size(mrB);
      if p~=0
         [l,l1]=size(mB);
         q=fix(ncm/l);

			if q<qDD
				IDD=IDD(:,1:q);
			else
				IDD=[IDD zeros(pDD,(q-qDD))];
			end
         if p<pDD
            IDD=IDD(1:p,:);
         else
            IDD=[IDD;zeros(p-pDD,q)];
         end
      end
      
      mrB=[mrB IDD];
      mB=[mB;idd];
   end;	

   for i=1:nRD
      IRD=iRDdaub8_2D(mfRD(:,1+(i-1)*nrRD:i*nrRD));
      [pRD,qRD]=size(IRD);
      ird=['(RD)' mRD(i,:)];
      [p,ncm]=size(mrB);
      if p~=0
         [l,l1]=size(mB);
         q=fix(ncm/l);

			if q<qRD
				IRD=IRD(:,1:q);
			else
				IRD=[IRD zeros(pRD,(q-qRD))];
			end;
         if p<pRD
            IRD=IRD(1:p,:);
         else
            IRD=[IRD;zeros(p-pRD,q)];
         end
      end
      
      mrB=[mrB IRD];
      mB=[mB;ird];
   end;	
   
   
   for i=1:nDR
      IDR=iDRdaub8_2D(mfDR(:,1+(i-1)*nrDR:i*nrDR));
      [pDR,qDR]=size(IDR);
      idr=['(DR)' mDR(i,:)];
      [p,ncm]=size(mrB);
      if p~=0
         [l,l1]=size(mB);
         q=fix(ncm/l);

			if q<qDR
				IDR=IDR(:,1:q);
			else
				IDR=[IDR zeros(pDR,(q-qDR))];
			end;
         if p<pDR
            IDR=IDR(1:p,:);
         else
            IDR=[IDR;zeros(p-pDR,q)];
         end
      end
      
      mrB=[mrB IDR];
      mB=[mB;idr];
   end;	
   eB=efRR+efDD+efRD+efDR;
   
   
else
   eB=eBinit;
   
   %ici, on peut modifier les coefficients de la base optimale suivant une
   %regle a definir :
   
   %Bmodif=matrice de taille size(B) dependant de B;
   %mrB=Bmodif;
   
   mrB=B;
   for k=1:nlev 
      mB=['(00)' mB];
   end
   
end;
end;

   
   
   
   
   


