function [ef,mf,ms]=wpack8_aux(x,nlev);
%programme auxiliaire pour 
%l'implementation de la decomposition 
%en paquets d'ondelettes (analyse 
%multi-resolution de Daubechies a 
%8 parametres). L'entropie est l'entropie de 
%Shannon (non normalisee). 

N=length(x);
ex=entr(x);
r=rdaub8(x);
d=ddaub8(x);
if nlev==1
	efs=entr(r);
	efd=entr(d);
   if efs+efd<ex;
      ir=irdaub8(r);
      id=iddaub8(d);
      ef=efs+efd;
      mf=[ir;id];
      ms=['R';'D'];
   else 
      ef=ex;
      mf=x;
      ms=['0'];
   end;
else
	[efs, mfs, mfss]=wpack8_aux(r,nlev-1);
   [efd, mfd, mfdd]=wpack8_aux(d,nlev-1);

mf=[];
ms=[];
if efs+efd<ex
	[nrs ncs]=size(mfs);

	for i=1:nrs
		[nrm ncm]=size(mf);
      ir=irdaub8(mfs(i,:));
      irr=['R' mfss(i,:)];
		if ncm~=0
			if ncm<length(ir)
				ir=ir(1:ncm);
			else
				ir=[ir zeros(1,(ncm-length(ir)))];
			end;
		end;
      mf=[mf;ir];
      ms=[ms; irr];
	end;	

	[nrd ncd]=size(mfd);

	for i=1:nrd
		[nrm ncm]=size(mf);
      id=iddaub8(mfd(i,:));
      idd=['D' mfdd(i,:)];
		if ncm ~= 0
			if ncm<length(id)
				id=id(1:ncm);
			else
				id=[id zeros(1,(ncm-length(id)))];
			end;
		end;
      mf=[mf;id];
      ms=[ms;idd];
	end;	
	ef=efs+efd;	
else
   ef=ex;
   mf=x; 
   for k=1:nlev,
      ms=['0' ms];
   end;
end;
end;