function f=wwig(h,g,s);

% f=wwig(h,g,s);
%Calcule la transformee de Wigner-Ville 
%fenetree (fenetre temporelle g, fenetre 
%frequentielle h, donnees en colonne). La 
%longueur G de g est inferieure a la longueur 
%H de h; de plus, on doit avoir
% length(s)>length(g)+2*length(h)
%L'axe horizontal est l'axe des temps. 
%L'axe vertical est l'axe des frequences. 
%L'intervalle de frequence est [0,pi/tau]
%(de haut en bas),ou tau est le pas d'echantillonnage; 
%Le signal est remplace par la transformee de Hilbert 
%de sa partie reelle. 

N=length(s);
H=length(h);
G=length(g);
x=[zeros(1,H-G),s,zeros(1,H+2*G)];
N=length(x);
h=h';
g=g';
xa=hilbert(x);
N1=1+G;
N2=N-H-G;
N0=N2-N1+1;
A=ones(N0,H);

for n=(H-G):N0
  for k=1:H
      s=g(1)*(xa(n+G+1+k)*conj(xa(n+G+1-k)));
      for m=2:G      
          s=s+2*g(m)*(xa(n+G+k+m)*conj(xa(n+G+m-k)))*h(k);
      end
%      A(n,k)=(1/G)*s*(2*h(k));
      A(n,k)=(1/G)*s;
   end
end


B=ones(N0-H+G,H);
for j=1:(N0-H+G),
B(j,:)=A(j+(H-G),:);
end
f1=(1/H)*fft(B',H);

m=size(f1);
for k=1:m(1),
   f(k,:)=f1(m(1)+1-k,:);
end 

    
    


