module init  
  
  implicit none
  
contains  
  
  subroutine initialisation
    
    use variables
    use doubler
    
    implicit none
    
    integer :: i,j, compteur,na
    real(pr) :: x,y,r, phix_inter, errmax, phimin, F , FF
    real(pr) :: theta, deb,fin,mid,norme,xp, yp, al, bl
   
    errmax = 0._pr

 ! on initialise phi2 et k
     xc = 0._pr
    yc = xc
    r0 = 0.65_pr
    omega = 5._pr

    do i=1,nx
       xx(i) = (float(i)-0.5_pr)*dx-1._pr
       do j=1,ny
          yy(j) = (float(j)-0.5_pr)*dy-1._pr
          r = sqrt((xx(i)-xc)**2 + (yy(j)-yc)**2)
          theta = asin((yy(j)-yc)/r)
          phi2(i,j) = -(r - r0 - 0.3_pr*sin(omega*theta))
  


       enddo
    enddo
    
  nbsigne = 0

  Tx = 0
  Ty = 0

  do j=1,ny
     do i=2,nx-1
        if (phi2(i,j)*phi2(i-1,j).le.0._pr) then
           xix2(1,i,j) = 1         
        else
           xix2(1,i,j) = 0
        endif
        if (phi2(i,j)*phi2(i+1,j).le.0._pr) then
           xix2(2,i,j) = 1         
           nbsigne = nbsigne + 1
           Tx(2,i,j) = nbsigne  
          
           Tx(1,i+1,j) = nbsigne
        else
           xix2(2,i,j) = 0
        endif
     enddo
  enddo


  do j=2,ny-1
     do i=1,nx       
        if (phi2(i,j)*phi2(i,j-1).le.0._pr) then
           xiy2(1,i,j) = 1         
        else
           xiy2(1,i,j) = 0
        endif
        if (phi2(i,j)*phi2(i,j+1).le.0._pr) then
           xiy2(2,i,j) = 1
           nbsigne = nbsigne + 1
           Ty(2,i,j) = nbsigne  
         
           Ty(1,i,j+1) = nbsigne
        else
           xiy2(2,i,j) = 0
        endif
     enddo
  enddo
print*, 'nbsigne',nbsigne



  
! calcul des positions des points d'interface 
! situes sur les axes des centres des mailles

  xinter = 0._pr
  yinter = 0._pr

  do i=1,nx-1
     do j=1,ny-1

        !calcul pour l'axe x   pour phi2     
        if  (xix2(2,i,j).eq.1) then
     
           ! dichotomie

           ! initial guess
           deb = xx(i)
           fin = xx(i+1)
           do na=1,9000
              mid = (deb+fin)/2._pr
              y = yy(j)
              x = deb
              r = sqrt((y-yc)**2+(x-xc)**2)
              theta = asin((y-yc)/r)
              F = sqrt( (x-xc)**2 + (y-yc)**2) - r0 - 0.2_pr*sin(omega*theta)
               x = mid
               r = sqrt((y-yc)**2+(x-xc)**2)
               theta = asin((y-yc)/r)
              FF = sqrt( (x-xc)**2 + (y-yc)**2) - r0 - 0.2_pr*sin(omega*theta)
             
              if (F*FF.lt.0._pr) then
                 fin = mid
              else
                 deb = mid
              endif
           enddo
           xinter(i,j) = mid



            if (abs((xinter(i,j)-xx(i))/dx).le.0.00000001) then
               xinter(i,j) =  float(i)*dx-1._pr
              endif
          if (abs((xinter(i,j)-xx(i+1))/dx).le.0.00000001) then
             xinter(i,j) =  float(i)*dx-1._pr
         endif


        endif
        
        !calcul pour l'axe y  pour phi2  
        if  (xiy2(2,i,j).eq.1) then
         
           ! dichotomie

           ! initial guess
           deb = yy(j)
          fin = yy(j+1)
           do na=1,9000
              mid = (deb+fin)/2._pr
              x = xx(i)
              y = deb
              r = sqrt((y-yc)**2+(x-xc)**2)
              theta = asin((y-yc)/r)
              F = sqrt( (x-xc)**2 + (y-yc)**2) - r0 - 0.2_pr*sin(omega*theta)
            
               y = mid
               r = sqrt((y-yc)**2+(x-xc)**2)
               theta = asin((y-yc)/r)
               FF = sqrt( (x-xc)**2 + (y-yc)**2) - r0 - 0.2_pr*sin(omega*theta)
            
              if (F*FF.lt.0._pr) then
                 fin = mid
              else
                 deb = mid
              endif
           enddo
           yinter(i,j) = mid

           if (abs((yinter(i,j)-yy(j))/dy).le.0.00000001) then
              yinter(i,j) =  float(j)*dy-1._pr
           endif
           if (abs((yinter(i,j)-yy(j+1))/dy).le.0.00000001) then
              yinter(i,j) =  float(j)*dy-1._pr
            endif

        endif       
     enddo
  enddo
 

end subroutine initialisation


end module init


