program sph
  
  use variables
  use doubler 
  use init
  use inverser
  use construction
  use util
use bord

  implicit none
  
  integer :: i,j, indx,indy
  character(len=50) ::  filepart1
  real(pr) :: x,sol,y,r,residuabs, errmax,theta,fix,fiy,grad
  real(pr), dimension(:), allocatable :: residu,solution
  character(len=50) ::  filepart2,filepart3,filepart4

 OPEN(10,file='C_IN.DAT',status='OLD')
    READ(10,*)
    read(10,*)nx
    READ(10,*)
    read(10,*)ny
    close(10)

 dx = 2.5_pr/float(nx)
  dy = 2._pr/float(ny)

  epsilon = 0.0000001_pr
  ntot = nx*ny 

  allocate(xx(1:nx))
  allocate(yy(1:ny))
  allocate(marqueur(1:nx,1:ny)) 
  allocate(phi2(1:nx,1:ny)) 
  allocate(phi2x(1:nx,1:ny)) 
  allocate(phi2y(1:nx,1:ny)) 
 allocate(xinter(1:nx,1:ny)) 
  allocate(yinter(1:nx,1:ny)) 
  allocate(k(1:nx,1:ny)) 
  allocate(Tx(1:2,1:nx,1:ny)) 
  allocate(Ty(1:2,1:nx,1:ny)) 
  allocate(xix2(1:2,1:nx,1:ny)) 
  allocate(xiy2(1:2,1:nx,1:ny))
 allocate(ipar(1:13)) 
  allocate(fpar(1:16)) 
  
  call initialisation

  taillemat = 8*ntot+10*nbsigne
  
  allocate(u(1:ntot+nbsigne))
  allocate(b(1:ntot+nbsigne))
  allocate(mat1(1:taillemat))
  allocate(mat2(1:taillemat))
  allocate(mat3(1:taillemat))
  allocate(solution(1:ntot+nbsigne))

  call assemblage
  
  allocate(matt1(1:indice))
  allocate(matt2(1:indice))
  allocate(matt3(1:indice))
  
  matt1 = mat1(1:indice)
  matt2 = mat2(1:indice)
  matt3 = mat3(1:indice)


  ! initial guess for systeme to solve
  
  do i=1,ntot+nbsigne
     u(i) = 1._pr
  enddo


  ! inversion systeme lineaire
  
  n = ntot+nbsigne
  nnz = indice
  
  call inverse_gmres  
  
  ! verif que le systeme lineaire est bien inversé
  allocate(residu(ntot+nbsigne))
  residu = 0.
  do i=1,indice
     residu(mat1(i)) = residu(mat1(i)) + mat3(i)*u(mat2(i))
  enddo
  
  residu = residu - b
  residuabs = 0._pr
  do i=1,ntot+nbsigne
     residuabs = dx*dy*residuabs + abs(residu(i))
  enddo
  print*, 'residu ', residuabs

  !!!!! ecriture resultat
   
  filepart2='u.vtk'
  filepart3='exact.vtk'
  filepart4='erreur.vtk'
  
  open(unit=79,file=filepart2,status='unknown') 
  open(unit=80,file=filepart3,status='unknown') 
  open(unit=81,file=filepart4,status='unknown') 
  
  write(79,'(1A26)') '# vtk DataFile Version 2.0'
  write(79,'(a)') 'solution u'
  write(79,'(a)') 'ASCII'
  write(79,'(a)') 'DATASET STRUCTURED_POINTS'
  write(79,'(a,I4,I4,I4)') 'DIMENSIONS', nx,ny,1
  write(79,'(a,E23.15,E23.15,E23.15)') 'ORIGIN', 0.,0.,0.
  write(79,'(a,E23.15,E23.15,E23.15)') 'SPACING', dx,dy, 1.
  write(79,'(a,I8)') 'POINT_DATA' , nx*ny
  write(79,'(a)') 'SCALARS values float 1'
  write(79,'(a)') 'LOOKUP_TABLE default'
  
  write(80,'(1A26)') '# vtk DataFile Version 2.0'
  write(80,'(a)') 'fleur sol'
  write(80,'(a)') 'ASCII'
  write(80,'(a)') 'DATASET STRUCTURED_POINTS'
  write(80,'(a,I4,I4,I4)') 'DIMENSIONS', nx,ny,1
  write(80,'(a,E23.15,E23.15,E23.15)') 'ORIGIN', 0.,0.,0.
  write(80,'(a,E23.15,E23.15,E23.15)') 'SPACING', dx,dy, 1.
  write(80,'(a,I8)') 'POINT_DATA' , nx*ny
  write(80,'(a)') 'SCALARS values float 1'
  write(80,'(a)') 'LOOKUP_TABLE default'
        
  write(81,'(1A26)') '# vtk DataFile Version 2.0'
  write(81,'(a)') 'fleur erreur'
  write(81,'(a)') 'ASCII'
  write(81,'(a)') 'DATASET STRUCTURED_POINTS'
  write(81,'(a,I4,I4,I4)') 'DIMENSIONS', nx,ny,1
  write(81,'(a,E23.15,E23.15,E23.15)') 'ORIGIN', 0.,0.,0.
  write(81,'(a,E23.15,E23.15,E23.15)') 'SPACING', dx,dy, 1.
  write(81,'(a,I8)') 'POINT_DATA' , nx*ny
  write(81,'(a)') 'SCALARS values float 1'
   write(81,'(a)') 'LOOKUP_TABLE default'

   errmax = 0.

   do j=1,ny
      do i=1,nx
         
         sol  = sin(3*xx(i))*sin(3*yy(j))
         
         if (phi2(i,j).ge.0._pr) then          
            if (errmax.lt.abs(sol-u(ind(i,j)))) then
               errmax = abs(sol-u(ind(i,j)))
            endif
         endif
         
         if (phi2(i,j).ge.0._pr) then
            write(79,*)u(ind(i,j))
         else
            write(79,*)0.
         endif
         
        if (phi2(i,j).ge.0._pr) then
           write(80,*) sol
        else
           write(80,*)0.
        endif

        if (phi2(i,j).ge.0._pr) then
           write(81,*)   sol-u(ind(i,j)) 
        else
           write(81,*)0.
        endif

     enddo
  enddo
  
print*, nx, errmax, errmax*nx

  close(79)
  close(80)
  close(81)
  
 

  deallocate(residu)
  deallocate(marqueur)
  deallocate(mat1)
  deallocate(mat2)
  deallocate(mat3)
  deallocate(matt1)
  deallocate(matt2) 
  deallocate(matt3)
  deallocate(phi2) 
  deallocate(phi2x) 
  deallocate(phi2y) 
  deallocate(xinter) 
  deallocate(yinter)  
  deallocate(xix2,xiy2) 
  deallocate(Tx,Ty)
  deallocate(u)
  deallocate(xx,yy)
  deallocate(k) 
  deallocate(b) 
  deallocate(ipar) 
  deallocate(fpar) 
  deallocate(solution)

end program sph



